CREATE OR REPLACE PACKAGE BODY       BizCrateWork AS

 /*
 ***************************************************************************************
 <֐>      : main
 <@\Tv>    : main
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  PROCEDURE main(
     TABLENAME IN  VARCHAR2
    ,SELECTTABLENAME IN VARCHAR2
    ,PERIOD IN    VARCHAR2 --
    ,DATEKBN          IN  VARCHAR2 --t敪
  ) AS
  BEGIN

    case PERIOD
      when COM00001.C_PRIOD_YYYY then
        createBizTable_YYYY(TABLENAME || '_YYYY',SELECTTABLENAME,DATEKBN);

      when COM00001.C_PRIOD_TERM then
        createBizTable_TERM(TABLENAME || '_TERM',SELECTTABLENAME,DATEKBN);

      when COM00001.C_PRIOD_YYYYMM then
        createBizTable_YYYYMM(TABLENAME || '_YYYYMM',SELECTTABLENAME,DATEKBN);

      when COM00001.C_PRIOD_WEEK then
        createBizTable_WEEK(TABLENAME || '_WEEK',SELECTTABLENAME,DATEKBN);

      else
        createBizTable_YYYY(TABLENAME || '_YYYY',SELECTTABLENAME,DATEKBN);
        createBizTable_TERM(TABLENAME || '_TERM',SELECTTABLENAME,DATEKBN);
        createBizTable_YYYYMM(TABLENAME || '_YYYYMM',SELECTTABLENAME,DATEKBN);
        createBizTable_WEEK(TABLENAME || '_WEEK',SELECTTABLENAME,DATEKBN);

    end case;

  END main;



 /*
 ***************************************************************************************
 <֐>      : createBizTable_YYYY
 <@\Tv>    : createBizTable_YYYY
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  PROCEDURE createBizTable_YYYY(
     TABLENAME IN  VARCHAR2
    ,SELECTTABLENAME IN VARCHAR2
    ,DATEKBN          IN  VARCHAR2 --t敪
  ) AS
    varSql varchar2(10000);
  BEGIN

   -- NWv폜
  if deleteBizTable(TABLENAME) = 0 then
    --NWv쐬
    varSql := createSQL_YYYY(TABLENAME,SELECTTABLENAME,DATEKBN);
    execute immediate varSql;
    --L[̍쐬
    execute immediate createPrimaryKey(TABLENAME);
    --INDEX̍쐬
    FOR wloop IN 1..15 LOOP
      execute immediate createIndex(TABLENAME,wloop);
    END LOOP;
    COMMIT;
   end if;

  END createBizTable_YYYY;



 /*
 ***************************************************************************************
 <֐>      : createBizTable_TERM
 <@\Tv>    : createBizTable_TERM
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  PROCEDURE createBizTable_TERM(
     TABLENAME IN  VARCHAR2
    ,SELECTTABLENAME IN VARCHAR2
    ,DATEKBN          IN  VARCHAR2 --t敪
  ) AS
    varSql varchar2(10000);
  BEGIN

   -- Wv폜
  if deleteBizTable(TABLENAME) = 0 then
    -- Wv쐬
    execute immediate createSQL_TERM(TABLENAME,SELECTTABLENAME,DATEKBN);
    --L[̍쐬
    execute immediate createPrimaryKey(TABLENAME);
    --INDEX̍쐬
    FOR wloop IN 1..15 LOOP
      execute immediate createIndex(TABLENAME,wloop);
    END LOOP;

    COMMIT;
   end if;

  END createBizTable_TERM;



 /*
 ***************************************************************************************
 <֐>      : createBizTable_YYYYMM
 <@\Tv>    : createBizTable_YYYYMM
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  PROCEDURE createBizTable_YYYYMM(
     TABLENAME IN  VARCHAR2
    ,SELECTTABLENAME IN VARCHAR2
    ,DATEKBN          IN  VARCHAR2 --t敪
  ) AS
    varSql varchar2(10000);
  BEGIN

   -- NWv폜
  if deleteBizTable(TABLENAME) = 0 then
    -- NWv쐬
    varSql := createSQL_YYYYMM(TABLENAME,SELECTTABLENAME,DATEKBN);
    execute immediate varSql;
    --L[̍쐬
    execute immediate createPrimaryKey(TABLENAME);
    --INDEX̍쐬
    FOR wloop IN 1..15 LOOP
      execute immediate createIndex(TABLENAME,wloop);
    END LOOP;

    COMMIT;
   end if;


  END createBizTable_YYYYMM;



 /*
 ***************************************************************************************
 <֐>      : createBizTable_WEEK
 <@\Tv>    : createBizTable_WEEK
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  PROCEDURE createBizTable_WEEK(
     TABLENAME IN  VARCHAR2
    ,SELECTTABLENAME IN VARCHAR2
    ,DATEKBN          IN  VARCHAR2 --t敪
  ) AS
    varSql varchar2(10000);
  BEGIN

   -- TWv폜
  if deleteBizTable(TABLENAME) = 0 then
    -- TWv쐬
    execute immediate createSQL_WEEK(TABLENAME,SELECTTABLENAME,DATEKBN);
    --L[̍쐬
    execute immediate createPrimaryKey(TABLENAME);
    --INDEX̍쐬
    FOR wloop IN 1..15 LOOP
      execute immediate createIndex(TABLENAME,wloop);
    END LOOP;

    COMMIT;
   end if;

  END createBizTable_WEEK;



 /*
 ***************************************************************************************
 <֐>      : deleteBizTable
 <@\Tv>    : deleteBizTable
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION deleteBizTable(
    TABLENAME IN  VARCHAR2
  ) RETURN INTEGER AS
    varSql varchar2(10000);
  BEGIN

		if deleteMviewBizTable(TABLENAME) = 0 then
	    varSql := 'DROP TABLE ' || TABLENAME || ' PURGE';
	    execute immediate varSql;
		end if;

	  RETURN 0;

  EXCEPTION
    WHEN OTHERS THEN
      RETURN 0;
  END deleteBizTable;

 /*
 ***************************************************************************************
 <֐>      : deleteBizTable
 <@\Tv>    : deleteBizTable
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION deleteMviewBizTable(
    TABLENAME IN  VARCHAR2
  ) RETURN INTEGER AS
    varSql varchar2(10000);
  BEGIN
    varSql := 'DROP MATERIALIZED VIEW ' || TABLENAME ;

    execute immediate varSql;

    RETURN 0;

  EXCEPTION
    WHEN OTHERS THEN
      RETURN 0;
  END deleteMviewBizTable;

 /*
 ***************************************************************************************
 <֐>      : createSQL_YYYY
 <@\Tv>    : createSQL_YYYY
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createSQL_YYYY(
    TABLENAME IN  VARCHAR2
   ,SELECTTABLENAME IN VARCHAR2
   ,DATEKBN          IN  VARCHAR2 --t敪
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN

    varSql :=
    'create table ' || TABLENAME ||
    ' nologging as ' ||			--2010/06/01@NOLOGGINGwǉ
    'SELECT B.EX_YYYY "VPERIOD" ' ||
      ',A.KEY1 "VKEY1" ' ||
      ',A.KEY2 "VKEY2" ' ||
      ',A.KEY3 "VKEY3" ' ||
      ',A.KEY4 "VKEY4" ' ||
      ',A.KEY5 "VKEY5" ' ||
      ',A.KEY6 "VKEY6" ' ||
      ',A.KEY7 "VKEY7" ' ||
      ',A.KEY8 "VKEY8" ' ||
      ',A.KEY9 "VKEY9" ' ||
      ',A.KEY10 "VKEY10" ' ||
      ',A.KEY11 "VKEY11" ' ||
      ',A.KEY12 "VKEY12" ' ||
      ',A.KEY13 "VKEY13" ' ||
      ',A.KEY14 "VKEY14" ' ||
      ',A.KEY15 "VKEY15" ' ||
      ',SUM(A.D1) "VD1" ' ||
      ',SUM(A.D2) "VD2" ' ||
      ',SUM(A.D3) "VD3" ' ||
      ',SUM(A.D4) "VD4" ' ||
      ',SUM(A.D5) "VD5" ' ||
      ',SUM(A.D6) "VD6" ' ||
      ',SUM(A.D7) "VD7" ' ||
      ',SUM(A.D8) "VD8" ' ||
      ',SUM(A.D9) "VD9" ' ||
      ',SUM(A.D10) "VD10" ' ||
      ',SUM(A.D11) "VD11" ' ||
      ',SUM(A.D12) "VD12" ' ||
      ',SUM(A.D13) "VD13" ' ||
      ',SUM(A.D14) "VD14" ' ||
      ',SUM(A.D15) "VD15" ' ||
      ',COUNT(*) "VCNTA" ' ||
      ',COUNT(A.D1) "VCNT1" ' ||
      ',COUNT(A.D2) "VCNT2" ' ||
      ',COUNT(A.D3) "VCNT3" ' ||
      ',COUNT(A.D4) "VCNT4" ' ||
      ',COUNT(A.D5) "VCNT5" ' ||
      ',COUNT(A.D6) "VCNT6" ' ||
      ',COUNT(A.D7) "VCNT7" ' ||
      ',COUNT(A.D8) "VCNT8" ' ||
      ',COUNT(A.D9) "VCNT9" ' ||
      ',COUNT(A.D10) "VCNT10" ' ||
      ',COUNT(A.D11) "VCNT11" ' ||
      ',COUNT(A.D12) "VCNT12" ' ||
      ',COUNT(A.D13) "VCNT13" ' ||
      ',COUNT(A.D14) "VCNT14" ' ||
      ',COUNT(A.D15) "VCNT15" ' ||
    'FROM ' ||
      SELECTTABLENAME || ' A ' ||
      ', EX_DAY B ' ||
    'WHERE ' ||
--      'A.DATE1 = B.EX_DATE ' ||
      'A.DATE' || DATEKBN || ' = B.EX_DATE ' ||
    'GROUP BY ' ||
      'B.EX_YYYY ' ||
      ',A.KEY1 ' ||
      ',A.KEY2 ' ||
      ',A.KEY3 ' ||
      ',A.KEY4 ' ||
      ',A.KEY5 ' ||
      ',A.KEY6 ' ||
      ',A.KEY7 ' ||
      ',A.KEY8 ' ||
      ',A.KEY9 ' ||
      ',A.KEY10 ' ||
      ',A.KEY11 ' ||
      ',A.KEY12 ' ||
      ',A.KEY13 ' ||
      ',A.KEY14 ' ||
      ',A.KEY15'
    ;
    RETURN varSql;

  END createSQL_YYYY;



 /*
 ***************************************************************************************
 <֐>      : createSQL_TERM
 <@\Tv>    : createSQL_TERM
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createSQL_TERM(
    TABLENAME IN  VARCHAR2
   ,SELECTTABLENAME IN VARCHAR2
      ,DATEKBN          IN  VARCHAR2 --t敪
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN
    varSql :=
    'create table ' || TABLENAME ||
    ' nologging as ' ||			--2010/06/01@NOLOGGINGwǉ
    'SELECT B.EX_TERM "VPERIOD" ' ||
      ',A.KEY1 "VKEY1" ' ||
      ',A.KEY2 "VKEY2" ' ||
      ',A.KEY3 "VKEY3" ' ||
      ',A.KEY4 "VKEY4" ' ||
      ',A.KEY5 "VKEY5" ' ||
      ',A.KEY6 "VKEY6" ' ||
      ',A.KEY7 "VKEY7" ' ||
      ',A.KEY8 "VKEY8" ' ||
      ',A.KEY9 "VKEY9" ' ||
      ',A.KEY10 "VKEY10" ' ||
      ',A.KEY11 "VKEY11" ' ||
      ',A.KEY12 "VKEY12" ' ||
      ',A.KEY13 "VKEY13" ' ||
      ',A.KEY14 "VKEY14" ' ||
      ',A.KEY15 "VKEY15" ' ||
      ',SUM(A.D1) "VD1" ' ||
      ',SUM(A.D2) "VD2" ' ||
      ',SUM(A.D3) "VD3" ' ||
      ',SUM(A.D4) "VD4" ' ||
      ',SUM(A.D5) "VD5" ' ||
      ',SUM(A.D6) "VD6" ' ||
      ',SUM(A.D7) "VD7" ' ||
      ',SUM(A.D8) "VD8" ' ||
      ',SUM(A.D9) "VD9" ' ||
      ',SUM(A.D10) "VD10" ' ||
      ',SUM(A.D11) "VD11" ' ||
      ',SUM(A.D12) "VD12" ' ||
      ',SUM(A.D13) "VD13" ' ||
      ',SUM(A.D14) "VD14" ' ||
      ',SUM(A.D15) "VD15" ' ||
      ',COUNT(*) "VCNTA" ' ||
      ',COUNT(A.D1) "VCNT1" ' ||
      ',COUNT(A.D2) "VCNT2" ' ||
      ',COUNT(A.D3) "VCNT3" ' ||
      ',COUNT(A.D4) "VCNT4" ' ||
      ',COUNT(A.D5) "VCNT5" ' ||
      ',COUNT(A.D6) "VCNT6" ' ||
      ',COUNT(A.D7) "VCNT7" ' ||
      ',COUNT(A.D8) "VCNT8" ' ||
      ',COUNT(A.D9) "VCNT9" ' ||
      ',COUNT(A.D10) "VCNT10" ' ||
      ',COUNT(A.D11) "VCNT11" ' ||
      ',COUNT(A.D12) "VCNT12" ' ||
      ',COUNT(A.D13) "VCNT13" ' ||
      ',COUNT(A.D14) "VCNT14" ' ||
      ',COUNT(A.D15) "VCNT15" ' ||
    'FROM ' ||
      SELECTTABLENAME || ' A ' ||
      ', EX_DAY B ' ||
    'WHERE ' ||
--      'A.DATE1 = B.EX_DATE ' ||
      'A.DATE' || DATEKBN || ' = B.EX_DATE ' ||
    'GROUP BY ' ||
      'B.EX_TERM ' ||
      ',A.KEY1 ' ||
      ',A.KEY2 ' ||
      ',A.KEY3 ' ||
      ',A.KEY4 ' ||
      ',A.KEY5 ' ||
      ',A.KEY6 ' ||
      ',A.KEY7 ' ||
      ',A.KEY8 ' ||
      ',A.KEY9 ' ||
      ',A.KEY10 ' ||
      ',A.KEY11 ' ||
      ',A.KEY12 ' ||
      ',A.KEY13 ' ||
      ',A.KEY14 ' ||
      ',A.KEY15 '
    ;
    RETURN varSql;
  END createSQL_TERM;



 /*
 ***************************************************************************************
 <֐>      : createSQL_YYYYMM
 <@\Tv>    : createSQL_YYYYMM
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createSQL_YYYYMM(
    TABLENAME IN  VARCHAR2
   ,SELECTTABLENAME IN VARCHAR2
   ,DATEKBN          IN  VARCHAR2 --t敪
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN
    varSql :=
    'create table ' || TABLENAME ||
    ' nologging as ' ||			--2010/06/01@NOLOGGINGwǉ
    'SELECT B.EX_YYYYMM "VPERIOD" ' ||
      ',A.KEY1 "VKEY1" ' ||
      ',A.KEY2 "VKEY2" ' ||
      ',A.KEY3 "VKEY3" ' ||
      ',A.KEY4 "VKEY4" ' ||
      ',A.KEY5 "VKEY5" ' ||
      ',A.KEY6 "VKEY6" ' ||
      ',A.KEY7 "VKEY7" ' ||
      ',A.KEY8 "VKEY8" ' ||
      ',A.KEY9 "VKEY9" ' ||
      ',A.KEY10 "VKEY10" ' ||
      ',A.KEY11 "VKEY11" ' ||
      ',A.KEY12 "VKEY12" ' ||
      ',A.KEY13 "VKEY13" ' ||
      ',A.KEY14 "VKEY14" ' ||
      ',A.KEY15 "VKEY15" ' ||
      ',SUM(A.D1) "VD1" ' ||
      ',SUM(A.D2) "VD2" ' ||
      ',SUM(A.D3) "VD3" ' ||
      ',SUM(A.D4) "VD4" ' ||
      ',SUM(A.D5) "VD5" ' ||
      ',SUM(A.D6) "VD6" ' ||
      ',SUM(A.D7) "VD7" ' ||
      ',SUM(A.D8) "VD8" ' ||
      ',SUM(A.D9) "VD9" ' ||
      ',SUM(A.D10) "VD10" ' ||
      ',SUM(A.D11) "VD11" ' ||
      ',SUM(A.D12) "VD12" ' ||
      ',SUM(A.D13) "VD13" ' ||
      ',SUM(A.D14) "VD14" ' ||
      ',SUM(A.D15) "VD15" ' ||
      ',COUNT(*) "VCNTA" ' ||
      ',COUNT(A.D1) "VCNT1" ' ||
      ',COUNT(A.D2) "VCNT2" ' ||
      ',COUNT(A.D3) "VCNT3" ' ||
      ',COUNT(A.D4) "VCNT4" ' ||
      ',COUNT(A.D5) "VCNT5" ' ||
      ',COUNT(A.D6) "VCNT6" ' ||
      ',COUNT(A.D7) "VCNT7" ' ||
      ',COUNT(A.D8) "VCNT8" ' ||
      ',COUNT(A.D9) "VCNT9" ' ||
      ',COUNT(A.D10) "VCNT10" ' ||
      ',COUNT(A.D11) "VCNT11" ' ||
      ',COUNT(A.D12) "VCNT12" ' ||
      ',COUNT(A.D13) "VCNT13" ' ||
      ',COUNT(A.D14) "VCNT14" ' ||
      ',COUNT(A.D15) "VCNT15" ' ||
    'FROM ' ||
      SELECTTABLENAME || ' A ' ||
      ', EX_DAY B ' ||
    'WHERE ' ||
--      'A.DATE1 = B.EX_DATE ' ||
      'A.DATE' || DATEKBN || ' = B.EX_DATE ' ||
    'GROUP BY ' ||
      'B.EX_YYYYMM ' ||
      ',A.KEY1 ' ||
      ',A.KEY2 ' ||
      ',A.KEY3 ' ||
      ',A.KEY4 ' ||
      ',A.KEY5 ' ||
      ',A.KEY6 ' ||
      ',A.KEY7 ' ||
      ',A.KEY8 ' ||
      ',A.KEY9 ' ||
      ',A.KEY10 ' ||
      ',A.KEY11 ' ||
      ',A.KEY12 ' ||
      ',A.KEY13 ' ||
      ',A.KEY14 ' ||
      ',A.KEY15 '
    ;
    RETURN varSql;
  END createSQL_YYYYMM;



 /*
 ***************************************************************************************
 <֐>      : createSQL_WEEK
 <@\Tv>    : createSQL_WEEK
 <߂l>      : Ȃ
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createSQL_WEEK(
    TABLENAME IN  VARCHAR2
   ,SELECTTABLENAME IN VARCHAR2
   ,DATEKBN          IN  VARCHAR2 --t敪
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN
    varSql :=
    'create table ' || TABLENAME ||
    ' nologging as ' ||			--2010/06/01@NOLOGGINGwǉ
    'SELECT B.EX_WEEK "VPERIOD" ' ||
      ',A.KEY1 "VKEY1" ' ||
      ',A.KEY2 "VKEY2" ' ||
      ',A.KEY3 "VKEY3" ' ||
      ',A.KEY4 "VKEY4" ' ||
      ',A.KEY5 "VKEY5" ' ||
      ',A.KEY6 "VKEY6" ' ||
      ',A.KEY7 "VKEY7" ' ||
      ',A.KEY8 "VKEY8" ' ||
      ',A.KEY9 "VKEY9" ' ||
      ',A.KEY10 "VKEY10" ' ||
      ',A.KEY11 "VKEY11" ' ||
      ',A.KEY12 "VKEY12" ' ||
      ',A.KEY13 "VKEY13" ' ||
      ',A.KEY14 "VKEY14" ' ||
      ',A.KEY15 "VKEY15" ' ||
      ',SUM(A.D1) "VD1" ' ||
      ',SUM(A.D2) "VD2" ' ||
      ',SUM(A.D3) "VD3" ' ||
      ',SUM(A.D4) "VD4" ' ||
      ',SUM(A.D5) "VD5" ' ||
      ',SUM(A.D6) "VD6" ' ||
      ',SUM(A.D7) "VD7" ' ||
      ',SUM(A.D8) "VD8" ' ||
      ',SUM(A.D9) "VD9" ' ||
      ',SUM(A.D10) "VD10" ' ||
      ',SUM(A.D11) "VD11" ' ||
      ',SUM(A.D12) "VD12" ' ||
      ',SUM(A.D13) "VD13" ' ||
      ',SUM(A.D14) "VD14" ' ||
      ',SUM(A.D15) "VD15" ' ||
      ',COUNT(*) "VCNTA" ' ||
      ',COUNT(A.D1) "VCNT1" ' ||
      ',COUNT(A.D2) "VCNT2" ' ||
      ',COUNT(A.D3) "VCNT3" ' ||
      ',COUNT(A.D4) "VCNT4" ' ||
      ',COUNT(A.D5) "VCNT5" ' ||
      ',COUNT(A.D6) "VCNT6" ' ||
      ',COUNT(A.D7) "VCNT7" ' ||
      ',COUNT(A.D8) "VCNT8" ' ||
      ',COUNT(A.D9) "VCNT9" ' ||
      ',COUNT(A.D10) "VCNT10" ' ||
      ',COUNT(A.D11) "VCNT11" ' ||
      ',COUNT(A.D12) "VCNT12" ' ||
      ',COUNT(A.D13) "VCNT13" ' ||
      ',COUNT(A.D14) "VCNT14" ' ||
      ',COUNT(A.D15) "VCNT15" ' ||
    'FROM ' ||
      SELECTTABLENAME || ' A ' ||
      ', EX_DAY B ' ||
    'WHERE ' ||
--      'A.DATE1 = B.EX_DATE ' ||
      'A.DATE' || DATEKBN || ' = B.EX_DATE ' ||
    'GROUP BY ' ||
      'B.EX_WEEK ' ||
      ',A.KEY1 ' ||
      ',A.KEY2 ' ||
      ',A.KEY3 ' ||
      ',A.KEY4 ' ||
      ',A.KEY5 ' ||
      ',A.KEY6 ' ||
      ',A.KEY7 ' ||
      ',A.KEY8 ' ||
      ',A.KEY9 ' ||
      ',A.KEY10 ' ||
      ',A.KEY11 ' ||
      ',A.KEY12 ' ||
      ',A.KEY13 ' ||
      ',A.KEY14 ' ||
      ',A.KEY15 '
    ;
    RETURN varSql;
  END createSQL_WEEK;



 /*
 ***************************************************************************************
 <֐>      : createPrimaryKey
 <@\Tv>    : p^̃e[u̎L[쐬B
 <߂l>      : rpk
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createPrimaryKey(
    TABLENAME IN  VARCHAR2  --CfbNXt^
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN
    varSql :=
      'ALTER TABLE ' || TABLENAME ||
      ' ADD PRIMARY KEY (' ||
      ' "VPERIOD",' ||
      ' VKEY1  ,' ||
      ' VKEY2  ,' ||
      ' VKEY3  ,' ||
      ' VKEY4  ,' ||
      ' VKEY5  ,' ||
      ' VKEY6  ,' ||
      ' VKEY7  ,' ||
      ' VKEY8  ,' ||
      ' VKEY9  ,' ||
      ' VKEY10 ,' ||
      ' VKEY11 ,' ||
      ' VKEY12 ,' ||
      ' VKEY13 ,' ||
      ' VKEY14 ,' ||
      ' VKEY15'   ||
      ' ) ' 
    ;
    RETURN varSql;

  END createPrimaryKey;




 /*
 ***************************************************************************************
 <֐>      : createIndex
 <@\Tv>    : CfbNX쐬B
 <߂l>      : rpk
 <l>        :
 ***************************************************************************************
 */
  FUNCTION createIndex(
     TABLENAME  IN  VARCHAR2  --CfbNXt^
    ,SEQ        IN  INTEGER   --CfbNX̘A
  ) RETURN VARCHAR2 AS
    varSql varchar2(10000);
  BEGIN
    varSql :=
    'CREATE INDEX IDX_' || TABLENAME || '_' || TO_CHAR(SEQ) ||
    ' ON ' || TABLENAME || 
    '("VPERIOD", VKEY' || TO_CHAR(SEQ) || ') NOLOGGING' --2010/06/01@NOLOGGINGwǉ
    ;
    RETURN varSql;

  END createIndex;

END BizCrateWork;
/
